{include file="$template/includes/pageheader.tpl" title=$LANG.clientarea.title}

<div class="container">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3">
            <div class="clientarea-sidebar">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareahome'}active{/if}" href="{$WEB_ROOT}/clientarea.php">
                            <i class="fa fa-home"></i> {$_ADMINLANG.clientarea.title}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareaproducts'}active{/if}" href="{$WEB_ROOT}/clientarea.php?action=services">
                            <i class="fa fa-server"></i> {$_ADMINLANG.clientarea.services}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareainvoices'}active{/if}" href="{$WEB_ROOT}/clientarea.php?action=invoices">
                            <i class="fa fa-file-text"></i> {$_ADMINLANG.clientarea.invoices}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareadomains'}active{/if}" href="{$WEB_ROOT}/clientarea.php?action=domains">
                            <i class="fa fa-globe"></i> {$_ADMINLANG.clientarea.domains}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'supportticketlist'}active{/if}" href="{$WEB_ROOT}/supporttickets.php">
                            <i class="fa fa-ticket"></i> {$_ADMINLANG.clientarea.supporttickets}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareadetails'}active{/if}" href="{$WEB_ROOT}/clientarea.php?action=details">
                            <i class="fa fa-user"></i> {$_ADMINLANG.clientarea.accountdetails}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $templatefile eq 'clientareachangepw'}active{/if}" href="{$WEB_ROOT}/clientarea.php?action=changepw">
                            <i class="fa fa-lock"></i> {$_ADMINLANG.clientarea.changepassword}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{$WEB_ROOT}/cart.php">
                            <i class="fa fa-shopping-cart"></i> {$_ADMINLANG.global.order}
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{$WEB_ROOT}/logout.php">
                            <i class="fa fa-sign-out"></i> {$_ADMINLANG.clientarea.logout}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="clientarea-content">
                {if $templatefile eq 'clientareahome'}
                    <h2 class="mb-4">{$_ADMINLANG.clientarea.welcome} {$clientsdetails.firstname}!</h2>
                    
                    <div class="row mb-4">
                        <div class="col-md-4 mb-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fa fa-server fa-3x text-primary mb-3"></i>
                                    <h3>{$clientsstats.productsnumactive}</h3>
                                    <p class="text-muted">{$_ADMINLANG.clientarea.activeservices}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fa fa-file-text fa-3x text-success mb-3"></i>
                                    <h3>{$clientsstats.invoicesdue}</h3>
                                    <p class="text-muted">{$_ADMINLANG.clientarea.invoicesdue}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card text-center">
                                <div class="card-body">
                                    <i class="fa fa-ticket fa-3x text-warning mb-3"></i>
                                    <h3>{$clientsstats.supportticketsopentotal}</h3>
                                    <p class="text-muted">{$_ADMINLANG.clientarea.supporttickets}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    {if $clientsstats.invoicesdue > 0}
                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle"></i> 
                            <strong>{$_ADMINLANG.clientarea.invoicesdue}:</strong> 
                            {$_ADMINLANG.clientarea.invoicesdueamount} {$clientsstats.invoicesdueamount}
                            <a href="{$WEB_ROOT}/clientarea.php?action=invoices" class="btn btn-sm btn-warning float-right">
                                {$_ADMINLANG.clientarea.viewall}
                            </a>
                        </div>
                    {/if}
                {/if}
                
                {if $templatefile eq 'clientareaproducts'}
                    <h2 class="mb-4">{$_ADMINLANG.clientarea.services}</h2>
                    
                    {if $services}
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>{$_ADMINLANG.clientarea.product}</th>
                                        <th>{$_ADMINLANG.clientarea.domain}</th>
                                        <th>{$_ADMINLANG.clientarea.regdate}</th>
                                        <th>{$_ADMINLANG.clientarea.nextduedate}</th>
                                        <th>{$_ADMINLANG.clientarea.status}</th>
                                        <th>{$_ADMINLANG.clientarea.actions}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach $services as $service}
                                    <tr>
                                        <td>{$service.product}</td>
                                        <td>{$service.domain}</td>
                                        <td>{$service.regdate}</td>
                                        <td>{$service.nextduedate}</td>
                                        <td>
                                            {if $service.status eq 'Active'}
                                                <span class="badge badge-success">{$service.status}</span>
                                            {elseif $service.status eq 'Suspended'}
                                                <span class="badge badge-warning">{$service.status}</span>
                                            {else}
                                                <span class="badge badge-danger">{$service.status}</span>
                                            {/if}
                                        </td>
                                        <td>
                                            <a href="{$WEB_ROOT}/clientarea.php?action=productdetails&id={$service.id}" class="btn btn-sm btn-primary">
                                                <i class="fa fa-cog"></i> {$_ADMINLANG.clientarea.manage}
                                            </a>
                                        </td>
                                    </tr>
                                    {/foreach}
                                </tbody>
                            </table>
                        </div>
                    {else}
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> {$_ADMINLANG.clientarea.noservices}
                        </div>
                    {/if}
                {/if}
                
                {if $templatefile eq 'clientareainvoices'}
                    <h2 class="mb-4">{$_ADMINLANG.clientarea.invoices}</h2>
                    
                    {if $invoices}
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>{$_ADMINLANG.invoices.invoicenum}</th>
                                        <th>{$_ADMINLANG.invoices.datecreated}</th>
                                        <th>{$_ADMINLANG.invoices.duedate}</th>
                                        <th>{$_ADMINLANG.invoices.total}</th>
                                        <th>{$_ADMINLANG.invoices.status}</th>
                                        <th>{$_ADMINLANG.clientarea.actions}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {foreach $invoices as $invoice}
                                    <tr>
                                        <td>#{$invoice.invoicenum}</td>
                                        <td>{$invoice.datecreated}</td>
                                        <td>{$invoice.duedate}</td>
                                        <td>{$invoice.total}</td>
                                        <td>
                                            {if $invoice.status eq 'Paid'}
                                                <span class="badge badge-success">{$invoice.status}</span>
                                            {elseif $invoice.status eq 'Unpaid'}
                                                <span class="badge badge-danger">{$invoice.status}</span>
                                            {else}
                                                <span class="badge badge-warning">{$invoice.status}</span>
                                            {/if}
                                        </td>
                                        <td>
                                            <a href="{$WEB_ROOT}/viewinvoice.php?id={$invoice.id}" class="btn btn-sm btn-primary">
                                                <i class="fa fa-eye"></i> {$_ADMINLANG.clientarea.view}
                                            </a>
                                        </td>
                                    </tr>
                                    {/foreach}
                                </tbody>
                            </table>
                        </div>
                    {else}
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> {$_ADMINLANG.clientarea.noinvoices}
                        </div>
                    {/if}
                {/if}
                
                {if $templatefile eq 'clientareadetails'}
                    <h2 class="mb-4">{$_ADMINLANG.clientarea.accountdetails}</h2>
                    
                    <form method="post" action="{$WEB_ROOT}/clientarea.php?action=details">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{$_ADMINLANG.clientarea.firstname}</label>
                                    <input type="text" name="firstname" class="form-control" value="{$clientsdetails.firstname}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{$_ADMINLANG.clientarea.lastname}</label>
                                    <input type="text" name="lastname" class="form-control" value="{$clientsdetails.lastname}" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>{$_ADMINLANG.clientarea.emailaddress}</label>
                            <input type="email" name="email" class="form-control" value="{$clientsdetails.email}" required>
                        </div>
                        
                        <div class="form-group">
                            <label>{$_ADMINLANG.clientarea.phonenumber}</label>
                            <input type="tel" name="phonenumber" class="form-control" value="{$clientsdetails.phonenumber}">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> {$_ADMINLANG.clientarea.savechanges}
                        </button>
                    </form>
                {/if}
                
                {if $templatefile eq 'clientareachangepw'}
                    <h2 class="mb-4">{$_ADMINLANG.clientarea.changepassword}</h2>
                    
                    {if $success}
                        <div class="alert alert-success">
                            <i class="fa fa-check-circle"></i> {$_ADMINLANG.clientarea.changepwsuccess}
                        </div>
                    {/if}
                    
                    {if $errormessage}
                        <div class="alert alert-danger">
                            <i class="fa fa-exclamation-circle"></i> {$errormessage}
                        </div>
                    {/if}
                    
                    <form method="post" action="{$WEB_ROOT}/clientarea.php?action=changepw">
                        <div class="form-group">
                            <label>{$_ADMINLANG.clientarea.currentpassword}</label>
                            <input type="password" name="currentpw" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                            <label>{$_ADMINLANG.clientarea.newpassword}</label>
                            <input type="password" name="newpw" class="form-control" required>
                            <small class="form-text text-muted">En az 8 karakter olmalıdır</small>
                        </div>
                        
                        <div class="form-group">
                            <label>{$_ADMINLANG.clientarea.confirmnewpassword}</label>
                            <input type="password" name="confirmpw" class="form-control" required>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> {$_ADMINLANG.clientarea.changepassword}
                        </button>
                    </form>
                {/if}
            </div>
        </div>
    </div>
</div>

{include file="$template/includes/pagefooter.tpl"}

